/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.api.biomes;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.biome.NetherBiomeData;
import net.fabricmc.fabric.impl.biome.TheEndBiomeData;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2841;
import net.minecraft.class_2893;
import net.minecraft.class_2922;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3754;
import net.minecraft.class_5281;
import net.minecraft.class_5284;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import net.minecraft.class_6012;
import net.minecraft.class_6544;
import net.minecraft.class_6686;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import ru.bclib.BCLib;
import ru.bclib.entity.BCLEntityWrapper;
import ru.bclib.interfaces.BiomeSourceAccessor;
import ru.bclib.interfaces.NoiseGeneratorSettingsProvider;
import ru.bclib.interfaces.SurfaceMaterialProvider;
import ru.bclib.interfaces.SurfaceProvider;
import ru.bclib.interfaces.SurfaceRuleProvider;
import ru.bclib.mixin.common.BiomeGenerationSettingsAccessor;
import ru.bclib.mixin.common.MobSpawnSettingsAccessor;
import ru.bclib.util.CollectionsUtil;
import ru.bclib.util.MHelper;
import ru.bclib.world.biomes.BCLBiome;
import ru.bclib.world.biomes.FabricBiomesData;
import ru.bclib.world.biomes.VanillaBiomeSettings;
import ru.bclib.world.features.BCLFeature;
import ru.bclib.world.generator.BiomePicker;

public class BiomeAPI {
    public static final BCLBiome EMPTY_BIOME = new BCLBiome(class_1972.field_9473.method_29177());
    public static final BiomePicker NETHER_BIOME_PICKER = new BiomePicker();
    public static final BiomePicker END_LAND_BIOME_PICKER = new BiomePicker();
    public static final BiomePicker END_VOID_BIOME_PICKER = new BiomePicker();
    private static final Map<class_2960, BCLBiome> ID_MAP = Maps.newHashMap();
    private static final Map<class_1959, BCLBiome> CLIENT = Maps.newHashMap();
    private static class_2378<class_1959> biomeRegistry;
    private static final Map<class_6880<class_6796>, Integer> FEATURE_ORDER;
    private static final MutableInt FEATURE_ORDER_ID;
    private static final Map<class_5321, List<BiConsumer<class_2960, class_6880<class_1959>>>> MODIFICATIONS;
    private static final Map<class_2960, class_6686.class_6708> SURFACE_RULES;
    private static final Set<SurfaceRuleProvider> MODIFIED_SURFACE_PROVIDERS;
    public static final BCLBiome NETHER_WASTES_BIOME;
    public static final BCLBiome CRIMSON_FOREST_BIOME;
    public static final BCLBiome WARPED_FOREST_BIOME;
    public static final BCLBiome SOUL_SAND_VALLEY_BIOME;
    public static final BCLBiome BASALT_DELTAS_BIOME;
    public static final BCLBiome THE_END;
    public static final BCLBiome END_MIDLANDS;
    public static final BCLBiome END_HIGHLANDS;
    public static final BCLBiome END_BARRENS;
    public static final BCLBiome SMALL_END_ISLANDS;

    private static void initFeatureOrder() {
        if (!FEATURE_ORDER.isEmpty()) {
            return;
        }
        class_5458.field_25933.method_29722().stream().filter(entry -> ((class_5321)entry.getKey()).method_29177().method_12836().equals("minecraft")).map(Map.Entry::getValue).map(biome -> (BiomeGenerationSettingsAccessor)biome.method_30970()).map(BiomeGenerationSettingsAccessor::bclib_getFeatures).forEach(stepFeatureSuppliers -> stepFeatureSuppliers.forEach(step -> step.forEach(feature -> FEATURE_ORDER.computeIfAbsent((class_6880<class_6796>)feature, f -> FEATURE_ORDER_ID.getAndIncrement()))));
    }

    public static void initRegistry(class_2378<class_1959> biomeRegistry) {
        if (biomeRegistry != BiomeAPI.biomeRegistry) {
            BiomeAPI.biomeRegistry = biomeRegistry;
            CLIENT.clear();
        }
    }

    public static void prepareNewLevel() {
        MODIFIED_SURFACE_PROVIDERS.forEach(p -> p.bclib_clearBiomeSources());
        MODIFIED_SURFACE_PROVIDERS.clear();
    }

    public static BCLBiome registerBiome(BCLBiome bclbiome) {
        if (class_5458.field_25933.method_10223(bclbiome.getID()) == null) {
            class_1959 biome = bclbiome.getBiome();
            class_2960 loc = bclbiome.getID();
            class_2378.method_10230((class_2378)class_5458.field_25933, (class_2960)loc, (Object)biome);
        }
        ID_MAP.put(bclbiome.getID(), bclbiome);
        return bclbiome;
    }

    public static BCLBiome registerSubBiome(BCLBiome parent, BCLBiome subBiome) {
        BiomeAPI.registerBiome(subBiome);
        parent.addSubBiome(subBiome);
        return subBiome;
    }

    public static BCLBiome registerSubBiome(BCLBiome parent, class_1959 biome, float genChance) {
        BCLBiome subBiome = new BCLBiome(biome, (VanillaBiomeSettings)((VanillaBiomeSettings.Builder)VanillaBiomeSettings.createVanilla().setGenChance(genChance)).build());
        return BiomeAPI.registerSubBiome(parent, subBiome);
    }

    public static BCLBiome registerNetherBiome(BCLBiome biome) {
        BiomeAPI.registerBiome(biome);
        NETHER_BIOME_PICKER.addBiome(biome);
        Random random = new Random(biome.getID().hashCode());
        class_6544.class_4762 parameters = class_6544.method_38117((float)MHelper.randRange(-1.5f, 1.5f, random), (float)MHelper.randRange(-1.5f, 1.5f, random), (float)MHelper.randRange(-1.5f, 1.5f, random), (float)MHelper.randRange(-1.5f, 1.5f, random), (float)MHelper.randRange(-1.5f, 1.5f, random), (float)MHelper.randRange(-1.5f, 1.5f, random), (float)random.nextFloat());
        class_5321 key = BiomeAPI.getBiomeKeyOrThrow(biome.getBiomeHolder());
        NetherBiomeData.addNetherBiome((class_5321)key, (class_6544.class_4762)parameters);
        return biome;
    }

    public static BCLBiome registerNetherBiome(class_1959 biome) {
        BCLBiome bclBiome = new BCLBiome(biome, null);
        NETHER_BIOME_PICKER.addBiome(bclBiome);
        BiomeAPI.registerBiome(bclBiome);
        return bclBiome;
    }

    public static BCLBiome registerEndLandBiome(BCLBiome biome) {
        BiomeAPI.registerBiome(biome);
        END_LAND_BIOME_PICKER.addBiome(biome);
        float weight = biome.getGenChance();
        class_5321 key = BiomeAPI.getBiomeKey(biome.getBiome());
        TheEndBiomeData.addEndBiomeReplacement((class_5321)class_1972.field_9442, (class_5321)key, (double)weight);
        TheEndBiomeData.addEndBiomeReplacement((class_5321)class_1972.field_9447, (class_5321)key, (double)weight);
        return biome;
    }

    public static BCLBiome registerEndLandBiome(class_6880<class_1959> biome) {
        BCLBiome bclBiome = new BCLBiome((class_1959)biome.comp_349(), null);
        END_LAND_BIOME_PICKER.addBiome(bclBiome);
        BiomeAPI.registerBiome(bclBiome);
        return bclBiome;
    }

    public static BCLBiome registerEndLandBiome(class_6880<class_1959> biome, float genChance) {
        BCLBiome bclBiome = new BCLBiome((class_1959)biome.comp_349(), (VanillaBiomeSettings)((VanillaBiomeSettings.Builder)VanillaBiomeSettings.createVanilla().setGenChance(genChance)).build());
        END_LAND_BIOME_PICKER.addBiome(bclBiome);
        BiomeAPI.registerBiome(bclBiome);
        return bclBiome;
    }

    public static BCLBiome registerEndVoidBiome(BCLBiome biome) {
        BiomeAPI.registerBiome(biome);
        END_VOID_BIOME_PICKER.addBiome(biome);
        float weight = biome.getGenChance();
        class_5321 key = BiomeAPI.getBiomeKeyOrThrow(biome.getBiomeHolder());
        TheEndBiomeData.addEndBiomeReplacement((class_5321)class_1972.field_9457, (class_5321)key, (double)weight);
        return biome;
    }

    public static BCLBiome registerEndVoidBiome(class_6880<class_1959> biome) {
        BCLBiome bclBiome = new BCLBiome((class_1959)biome.comp_349(), null);
        END_VOID_BIOME_PICKER.addBiome(bclBiome);
        BiomeAPI.registerBiome(bclBiome);
        return bclBiome;
    }

    public static BCLBiome registerEndVoidBiome(class_6880<class_1959> biome, float genChance) {
        BCLBiome bclBiome = new BCLBiome((class_1959)biome.comp_349(), (VanillaBiomeSettings)((VanillaBiomeSettings.Builder)VanillaBiomeSettings.createVanilla().setGenChance(genChance)).build());
        END_VOID_BIOME_PICKER.addBiome(bclBiome);
        BiomeAPI.registerBiome(bclBiome);
        return bclBiome;
    }

    public static BCLBiome getFromBiome(class_6880<class_1959> biome) {
        if (biomeRegistry == null) {
            return EMPTY_BIOME;
        }
        return ID_MAP.getOrDefault(((class_5321)biome.method_40230().orElseThrow()).method_29177(), EMPTY_BIOME);
    }

    @Environment(value=EnvType.CLIENT)
    public static BCLBiome getRenderBiome(class_1959 biome) {
        BCLBiome endBiome = CLIENT.get(biome);
        if (endBiome == null) {
            class_310 minecraft = class_310.method_1551();
            class_2960 id = minecraft.field_1687.method_30349().method_30530(class_2378.field_25114).method_10221((Object)biome);
            endBiome = id == null ? EMPTY_BIOME : ID_MAP.getOrDefault(id, EMPTY_BIOME);
            CLIENT.put(biome, endBiome);
        }
        return endBiome;
    }

    @Nullable
    public static class_5321 getBiomeKey(class_1959 biome) {
        return class_5458.field_25933.method_29113((Object)biome).orElseGet(() -> biomeRegistry != null ? (class_5321)biomeRegistry.method_29113((Object)biome).orElse(null) : null);
    }

    public static class_2960 getBiomeID(class_1959 biome) {
        class_2960 id = class_5458.field_25933.method_10221((Object)biome);
        if (id == null && biomeRegistry != null) {
            id = biomeRegistry.method_10221((Object)biome);
        }
        return id == null ? EMPTY_BIOME.getID() : id;
    }

    public static class_2960 getBiomeID(class_6880<class_1959> biome) {
        Optional oKey = biome.method_40230();
        if (oKey.isPresent()) {
            return ((class_5321)oKey.get()).method_29177();
        }
        return null;
    }

    public static class_5321 getBiomeKey(class_6880<class_1959> biome) {
        return biome.method_40230().orElse(null);
    }

    public static class_5321 getBiomeKeyOrThrow(class_6880<class_1959> biome) {
        return (class_5321)biome.method_40230().orElseThrow();
    }

    public static BCLBiome getBiome(class_2960 biomeID) {
        return ID_MAP.getOrDefault(biomeID, EMPTY_BIOME);
    }

    public static BCLBiome getBiome(class_1959 biome) {
        return BiomeAPI.getBiome(BiomeAPI.getBiomeID(biome));
    }

    public static BCLBiome getBiome(class_6880<class_1959> biome) {
        return BiomeAPI.getBiome(BiomeAPI.getBiomeID(biome));
    }

    public static boolean hasBiome(class_2960 biomeID) {
        return ID_MAP.containsKey(biomeID);
    }

    public static void loadFabricAPIBiomes() {
        FabricBiomesData.NETHER_BIOMES.forEach(key -> {
            Optional optional;
            if (!BiomeAPI.hasBiome(key.method_29177()) && (optional = class_5458.field_25933.method_40264(key)).isPresent()) {
                BiomeAPI.registerNetherBiome((class_1959)((class_6880)optional.get()).comp_349());
            }
        });
        FabricBiomesData.END_LAND_BIOMES.forEach((key, weight) -> {
            Optional optional;
            if (!BiomeAPI.hasBiome(key.method_29177()) && (optional = class_5458.field_25933.method_40264(key)).isPresent()) {
                BiomeAPI.registerEndLandBiome((class_6880<class_1959>)((class_6880)optional.get()), weight.floatValue());
            }
        });
        FabricBiomesData.END_VOID_BIOMES.forEach((key, weight) -> {
            Optional optional;
            if (!BiomeAPI.hasBiome(key.method_29177()) && (optional = class_5458.field_25933.method_40264(key)).isPresent()) {
                BiomeAPI.registerEndVoidBiome((class_6880<class_1959>)((class_6880)optional.get()), weight.floatValue());
            }
        });
    }

    @Nullable
    public static class_6880<class_1959> getFromRegistry(class_2960 key) {
        return (class_6880)class_5458.field_25933.method_40264(class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)key)).orElseThrow();
    }

    @Nullable
    public static class_6880<class_1959> getFromRegistry(class_5321<class_1959> key) {
        return class_5458.field_25933.method_40268(key);
    }

    public static boolean isDatapackBiome(class_2960 biomeID) {
        return BiomeAPI.getFromRegistry(biomeID) == null;
    }

    public static boolean isNetherBiome(class_2960 biomeID) {
        return BiomeAPI.pickerHasBiome(NETHER_BIOME_PICKER, biomeID);
    }

    public static boolean isEndBiome(class_2960 biomeID) {
        return BiomeAPI.pickerHasBiome(END_LAND_BIOME_PICKER, biomeID) || BiomeAPI.pickerHasBiome(END_VOID_BIOME_PICKER, biomeID);
    }

    private static boolean pickerHasBiome(BiomePicker picker, class_2960 key) {
        return picker.getBiomes().stream().filter(biome -> biome.getID().equals((Object)key)).findFirst().isPresent();
    }

    public static void registerBiomeModification(class_5321 dimensionID, BiConsumer<class_2960, class_6880<class_1959>> modification) {
        List modifications = MODIFICATIONS.computeIfAbsent(dimensionID, k -> Lists.newArrayList());
        modifications.add(modification);
    }

    public static void registerOverworldBiomeModification(BiConsumer<class_2960, class_6880<class_1959>> modification) {
        BiomeAPI.registerBiomeModification(class_1937.field_25179, modification);
    }

    public static void registerNetherBiomeModification(BiConsumer<class_2960, class_6880<class_1959>> modification) {
        BiomeAPI.registerBiomeModification(class_1937.field_25180, modification);
    }

    public static void registerEndBiomeModification(BiConsumer<class_2960, class_6880<class_1959>> modification) {
        BiomeAPI.registerBiomeModification(class_1937.field_25181, modification);
    }

    public static void applyModifications(class_3218 level) {
        class_5284 noiseGeneratorSettings = null;
        class_2794 chunkGenerator = level.method_14178().method_12129();
        class_1966 source = chunkGenerator.method_12098();
        Set biomes = source.method_28443();
        if (chunkGenerator instanceof NoiseGeneratorSettingsProvider) {
            NoiseGeneratorSettingsProvider gen = (NoiseGeneratorSettingsProvider)chunkGenerator;
            noiseGeneratorSettings = gen.bclib_getNoiseGeneratorSettings();
        }
        if (noiseGeneratorSettings == null) {
            if (level.method_27983() == class_1937.field_25180) {
                noiseGeneratorSettings = (class_5284)class_5458.field_26375.method_29107(class_5284.field_26357);
            } else if (level.method_27983() == class_1937.field_25181) {
                noiseGeneratorSettings = (class_5284)class_5458.field_26375.method_29107(class_5284.field_26358);
            }
        }
        List<BiConsumer<class_2960, class_6880<class_1959>>> modifications = MODIFICATIONS.get(level.method_27983());
        for (class_6880 biomeHolder : biomes) {
            if (!biomeHolder.method_40227()) continue;
            BiomeAPI.applyModificationsAndUpdateFeatures(modifications, (class_6880<class_1959>)biomeHolder);
        }
        if (noiseGeneratorSettings != null) {
            SurfaceRuleProvider provider = (SurfaceRuleProvider)SurfaceRuleProvider.class.cast(noiseGeneratorSettings);
            MODIFIED_SURFACE_PROVIDERS.add(provider);
            provider.bclib_addBiomeSource(source);
        } else {
            BCLib.LOGGER.warning("No generator for " + source, new Object[0]);
        }
        ((BiomeSourceAccessor)source).bclRebuildFeatures();
    }

    private static void applyModificationsAndUpdateFeatures(List<BiConsumer<class_2960, class_6880<class_1959>>> modifications, class_6880<class_1959> biome) {
        class_2960 biomeID = BiomeAPI.getBiomeID(biome);
        if (modifications != null) {
            modifications.forEach(consumer -> consumer.accept(biomeID, biome));
        }
        BiomeAPI.sortBiomeFeatures(biome);
    }

    public static void sortBiomeFeatures(class_6880<class_1959> biome) {
        class_5485 settings = ((class_1959)biome.comp_349()).method_30970();
        BiomeGenerationSettingsAccessor accessor = (BiomeGenerationSettingsAccessor)settings;
        List<class_6885<class_6796>> featureList = CollectionsUtil.getMutable(accessor.bclib_getFeatures());
        int size = featureList.size();
        for (int i = 0; i < size; ++i) {
            List<class_6880<class_6796>> features = BiomeAPI.getFeaturesListCopy(featureList, i);
            BiomeAPI.sortFeatures(features);
            featureList.set(i, (class_6885<class_6796>)class_6885.method_40242(features));
        }
        accessor.bclib_setFeatures(featureList);
    }

    private static List<class_6686.class_6708> getRuleSourcesForBiomes(Set<class_6880<class_1959>> biomes) {
        Set<class_2960> biomeIDs = biomes.stream().map(biome -> BiomeAPI.getBiomeID((class_6880<class_1959>)biome)).collect(Collectors.toSet());
        return BiomeAPI.getRuleSourcesFromIDs(biomeIDs);
    }

    public static List<class_6686.class_6708> getRuleSources(Set<class_1966> sources) {
        HashSet<class_6880<class_1959>> biomes = new HashSet<class_6880<class_1959>>();
        for (class_1966 s : sources) {
            biomes.addAll(s.method_28443());
        }
        return BiomeAPI.getRuleSourcesForBiomes(biomes);
    }

    private static List<class_6686.class_6708> getRuleSourcesFromIDs(Set<class_2960> biomeIDs) {
        ArrayList rules = Lists.newArrayList();
        SURFACE_RULES.forEach((biomeID, rule) -> {
            if (biomeIDs.contains(biomeID)) {
                rules.add(rule);
            }
        });
        return rules;
    }

    public static void addBiomeFeature(class_6880<class_1959> biome, BCLFeature feature) {
        BiomeAPI.addBiomeFeature(biome, feature.getDecoration(), feature.getPlacedFeature());
    }

    public static void addBiomeFeature(class_6880<class_1959> biome, class_2893.class_2895 step, class_6880<class_6796> ... featureList) {
        BiomeAPI.addBiomeFeature(biome, step, List.of(featureList));
    }

    private static void addBiomeFeature(class_6880<class_1959> biome, class_2893.class_2895 step, List<class_6880<class_6796>> additionalFeatures) {
        BiomeGenerationSettingsAccessor accessor = (BiomeGenerationSettingsAccessor)((class_1959)biome.comp_349()).method_30970();
        List<class_6885<class_6796>> allFeatures = CollectionsUtil.getMutable(accessor.bclib_getFeatures());
        List<class_6880<class_6796>> features = BiomeAPI.getFeaturesListCopy(allFeatures, step);
        for (class_6880<class_6796> feature : additionalFeatures) {
            if (features.contains(feature)) continue;
            features.add(feature);
        }
        allFeatures.set(step.ordinal(), (class_6885<class_6796>)class_6885.method_40242(features));
        com.google.common.base.Supplier flowerFeatures = Suppliers.memoize(() -> (List)allFeatures.stream().flatMap(class_6885::method_40239).map(class_6880::comp_349).flatMap(class_6796::method_39643).filter(configuredFeature -> configuredFeature.comp_332() == class_3031.field_21219).collect(ImmutableList.toImmutableList()));
        com.google.common.base.Supplier featureSet = Suppliers.memoize(() -> allFeatures.stream().flatMap(class_6885::method_40239).map(class_6880::comp_349).collect(Collectors.toSet()));
        accessor.bclib_setFeatures(allFeatures);
        accessor.bclib_setFeatureSet((Supplier<Set<class_6796>>)featureSet);
        accessor.bclib_setFlowerFeatures((Supplier<List<class_2975<?, ?>>>)flowerFeatures);
    }

    public static void addBiomeCarver(class_1959 biome, class_6880<? extends class_2922<?>> carver, class_2893.class_2894 stage) {
        BiomeGenerationSettingsAccessor accessor = (BiomeGenerationSettingsAccessor)biome.method_30970();
        Map<class_2893.class_2894, class_6885<class_2922<?>>> carverMap = CollectionsUtil.getMutable(accessor.bclib_getCarvers());
        class_6885<class_2922<?>> carvers = carverMap.get(stage);
        List<Object> carverList = carvers == null ? Lists.newArrayList() : carvers.method_40239().toList();
        carverList.add(carver);
        carverMap.put(stage, (class_6885<class_2922<?>>)class_6885.method_40242((List)carverList));
        accessor.bclib_setCarvers(carverMap);
    }

    public static void addSurfaceRule(class_2960 biomeID, class_6686.class_6708 source) {
        SURFACE_RULES.put(biomeID, source);
    }

    @Nullable
    public static class_6686.class_6708 getSurfaceRule(class_2960 biomeID) {
        return SURFACE_RULES.get(biomeID);
    }

    public static <M extends class_1308> void addBiomeMobSpawn(class_6880<class_1959> biome, BCLEntityWrapper<M> entityType, int weight, int minGroupCount, int maxGroupCount) {
        if (entityType.canSpawn()) {
            BiomeAPI.addBiomeMobSpawn(biome, entityType.type(), weight, minGroupCount, maxGroupCount);
        }
    }

    public static <M extends class_1308> void addBiomeMobSpawn(class_6880<class_1959> biome, class_1299<M> entityType, int weight, int minGroupCount, int maxGroupCount) {
        class_1311 category = entityType.method_5891();
        MobSpawnSettingsAccessor accessor = (MobSpawnSettingsAccessor)((class_1959)biome.comp_349()).method_30966();
        Map<class_1311, class_6012<class_5483.class_1964>> spawners = CollectionsUtil.getMutable(accessor.bcl_getSpawners());
        ArrayList mobs = spawners.containsKey(category) ? CollectionsUtil.getMutable(spawners.get(category).method_34994()) : Lists.newArrayList();
        mobs.add(new class_5483.class_1964(entityType, weight, minGroupCount, maxGroupCount));
        spawners.put(category, (class_6012<class_5483.class_1964>)class_6012.method_34988((List)mobs));
        accessor.bcl_setSpawners(spawners);
    }

    public static class_2680 getBiomeSurfaceBlock(class_2338 pos, class_6880<class_1959> biome, class_3218 level) {
        class_2794 generator = level.method_14178().method_12129();
        if (generator instanceof class_3754) {
            SurfaceProvider provider = (SurfaceProvider)SurfaceProvider.class.cast(generator);
            return provider.bclib_getSurface(pos, biome, level);
        }
        return class_2246.field_10124.method_9564();
    }

    public static Optional<class_2680> findTopMaterial(class_5281 world, class_2338 pos) {
        return BiomeAPI.findTopMaterial(BiomeAPI.getBiome((class_6880<class_1959>)world.method_23753(pos)));
    }

    public static Optional<class_2680> findTopMaterial(class_6880<class_1959> biome) {
        return BiomeAPI.findTopMaterial(BiomeAPI.getBiome((class_1959)biome.comp_349()));
    }

    public static Optional<class_2680> findTopMaterial(class_1959 biome) {
        return BiomeAPI.findTopMaterial(BiomeAPI.getBiome(biome));
    }

    public static Optional<class_2680> findTopMaterial(BCLBiome biome) {
        if (biome instanceof SurfaceMaterialProvider) {
            SurfaceMaterialProvider smp = (SurfaceMaterialProvider)((Object)biome);
            return Optional.of(smp.getTopMaterial());
        }
        return Optional.empty();
    }

    public static Optional<class_2680> findUnderMaterial(class_5281 world, class_2338 pos) {
        return BiomeAPI.findUnderMaterial(BiomeAPI.getBiome((class_6880<class_1959>)world.method_23753(pos)));
    }

    public static Optional<class_2680> findUnderMaterial(class_6880<class_1959> biome) {
        return BiomeAPI.findUnderMaterial(BiomeAPI.getBiome((class_1959)biome.comp_349()));
    }

    public static Optional<class_2680> findUnderMaterial(class_1959 biome) {
        return BiomeAPI.findUnderMaterial(BiomeAPI.getBiome(biome));
    }

    public static Optional<class_2680> findUnderMaterial(BCLBiome biome) {
        if (biome instanceof SurfaceMaterialProvider) {
            SurfaceMaterialProvider smp = (SurfaceMaterialProvider)((Object)biome);
            return Optional.of(smp.getUnderMaterial());
        }
        return Optional.empty();
    }

    public static void setBiome(class_2791 chunk, class_2338 pos, class_6880<class_1959> biome) {
        int sectionY = pos.method_10264() - chunk.method_31607() >> 4;
        class_2841 biomes = chunk.method_38259(sectionY).method_38294();
        biomes.method_35321((pos.method_10263() & 0xF) >> 2, (pos.method_10264() & 0xF) >> 2, (pos.method_10260() & 0xF) >> 2, biome);
    }

    public static void setBiome(class_1936 level, class_2338 pos, class_6880<class_1959> biome) {
        class_2791 chunk = level.method_22350(pos);
        BiomeAPI.setBiome(chunk, pos, biome);
    }

    private static void sortFeatures(List<class_6880<class_6796>> features) {
        BiomeAPI.initFeatureOrder();
        HashSet featuresWithoutDuplicates = Sets.newHashSet();
        features.forEach(holder -> featuresWithoutDuplicates.add(holder));
        if (featuresWithoutDuplicates.size() != features.size()) {
            features.clear();
            featuresWithoutDuplicates.forEach(feature -> features.add((class_6880<class_6796>)feature));
        }
        features.forEach(feature -> FEATURE_ORDER.computeIfAbsent((class_6880<class_6796>)feature, f -> FEATURE_ORDER_ID.getAndIncrement()));
        features.sort((f1, f2) -> {
            int v1 = FEATURE_ORDER.getOrDefault(f1, 70000);
            int v2 = FEATURE_ORDER.getOrDefault(f2, 70000);
            return Integer.compare(v1, v2);
        });
    }

    private static List<Supplier<class_6796>> getList(class_2893.class_2895 step, List<List<Supplier<class_6796>>> lists) {
        int index = step.ordinal();
        if (lists.size() <= index) {
            for (int i = lists.size(); i <= index; ++i) {
                lists.add(Lists.newArrayList());
            }
        }
        List<Supplier<class_6796>> list = CollectionsUtil.getMutable(lists.get(index));
        lists.set(index, list);
        return list;
    }

    private static List<class_6880<class_6796>> getFeaturesListCopy(List<class_6885<class_6796>> features, class_2893.class_2895 step) {
        return BiomeAPI.getFeaturesListCopy(features, step.ordinal());
    }

    private static List<class_6880<class_6796>> getFeaturesListCopy(List<class_6885<class_6796>> features, int index) {
        while (features.size() <= index) {
            features.add((class_6885<class_6796>)class_6885.method_40242((List)Lists.newArrayList()));
        }
        return features.get(index).method_40239().collect(Collectors.toList());
    }

    static {
        FEATURE_ORDER = Maps.newHashMap();
        FEATURE_ORDER_ID = new MutableInt(0);
        MODIFICATIONS = Maps.newHashMap();
        SURFACE_RULES = Maps.newHashMap();
        MODIFIED_SURFACE_PROVIDERS = new HashSet<SurfaceRuleProvider>(8);
        NETHER_WASTES_BIOME = BiomeAPI.registerNetherBiome((class_1959)BiomeAPI.getFromRegistry((class_5321<class_1959>)class_1972.field_9461).comp_349());
        CRIMSON_FOREST_BIOME = BiomeAPI.registerNetherBiome((class_1959)BiomeAPI.getFromRegistry((class_5321<class_1959>)class_1972.field_22077).comp_349());
        WARPED_FOREST_BIOME = BiomeAPI.registerNetherBiome((class_1959)BiomeAPI.getFromRegistry((class_5321<class_1959>)class_1972.field_22075).comp_349());
        SOUL_SAND_VALLEY_BIOME = BiomeAPI.registerNetherBiome((class_1959)BiomeAPI.getFromRegistry((class_5321<class_1959>)class_1972.field_22076).comp_349());
        BASALT_DELTAS_BIOME = BiomeAPI.registerNetherBiome((class_1959)BiomeAPI.getFromRegistry((class_5321<class_1959>)class_1972.field_23859).comp_349());
        THE_END = BiomeAPI.registerEndLandBiome(BiomeAPI.getFromRegistry((class_5321<class_1959>)class_1972.field_9411));
        END_MIDLANDS = BiomeAPI.registerSubBiome(THE_END, (class_1959)BiomeAPI.getFromRegistry((class_5321<class_1959>)class_1972.field_9447).comp_349(), 0.5f);
        END_HIGHLANDS = BiomeAPI.registerSubBiome(THE_END, (class_1959)BiomeAPI.getFromRegistry((class_5321<class_1959>)class_1972.field_9442).comp_349(), 0.5f);
        END_BARRENS = BiomeAPI.registerEndVoidBiome(BiomeAPI.getFromRegistry(new class_2960("end_barrens")));
        SMALL_END_ISLANDS = BiomeAPI.registerEndVoidBiome(BiomeAPI.getFromRegistry(new class_2960("small_end_islands")));
    }

    static class StructureID {
        public final class_2960 biomeID;
        public final class_5312 structure;

        StructureID(class_2960 biomeID, class_5312 structure) {
            this.biomeID = biomeID;
            this.structure = structure;
        }

        public String toString() {
            return "StructureID{id=" + this.biomeID + ", structure=" + this.structure + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StructureID that = (StructureID)o;
            return this.biomeID.equals((Object)that.biomeID) && this.structure.equals(that.structure);
        }

        public int hashCode() {
            return Objects.hash(this.biomeID, this.structure);
        }
    }
}

